


import java.time.LocalDateTime;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.scene.layout.*;
import javafx.scene.control.*;
import javafx.scene.text.*;
import javafx.geometry.*;
import javafx.scene.shape.*;
import javafx.scene.paint.*;
import java.time.*;
import java.util.*;
import java.time.temporal.*;



public class Calendar extends Application
{
    private BorderPane containerPane = new BorderPane();
    private GridPane monthPane = new GridPane();
    private Scene scene;
    private LocalDateTime date;
    private String appointmentFile = "appointmentFile.csv";
    private StackPane p1;
    private List <Text> dayL = new ArrayList();
    private List <String> monthL = new ArrayList();
    private boolean grey;
    private int counter;
    private int counter2;
    private Button lBtn = new Button("<");
    private Button rBtn = new Button(">");
    private Button tBtn = new Button("Today");
    private int month;  
    private int year;
    private int today;
    private Text monthT;
    private Text yearT;

    private Circle cToday;
    private String jan = "JANUARAY";
    private String feb = "FEBURARY";
    private String mar = "MARCH";
    private String apr = "APRIL";
    private String may = "MAY";
    private String jun = "JUNE";
    private String jul = "JULY";
    private String aug = "AUGUST";
    private String sep = "SEPTEMBER";
    private String oct = "OCTOBER";
    private String nov = "NOVEMEBER";
    private String dec = "DECEMEBER";
    private HBox bMon = new HBox(20);
    private HBox bTop = new HBox(10);
    private HBox bMain = new HBox(605);    
    private boolean mMonth;
    private int startOfNMon;
    private int endOfLMon;
    private int firstDay;
    private int monthBefore;
    private int monthAfter;
    private Text t1;
    private Scene appointmentScene;
    private Pane appointmentPane = new Pane();
    private Stage appointmentStage = new Stage();
    private TextField titleT;
    private ComboBox<String> hr;
    private ComboBox<String> min;
    
    @Override
    public void start(Stage primaryStage)
    {
        scene = new Scene(containerPane, 900, 650);
        setupCalendarPane();
        primaryStage.setTitle("Calendar");
        primaryStage.setMinWidth(900);
        primaryStage.setMinHeight(620);
        primaryStage.setScene(scene);
        primaryStage.show();
        
        
        //Use the following if you decide to complete the extra credit
        
        appointmentScene = new Scene(appointmentPane, 350, 250);
        setupAppointmentPane();
        appointmentStage.setTitle("Add Event");
        appointmentStage.setScene(appointmentScene);
        
        /*
        displayAppointments();
        */
    }

    
    public void setupCalendarPane()
    {        
        monthL.add(jan);
        monthL.add(feb);
        monthL.add(mar);
        monthL.add(apr);
        monthL.add(may);
        monthL.add(jun);
        monthL.add(jul);
        monthL.add(aug);
        monthL.add(sep);
        monthL.add(oct);
        monthL.add(nov);
        monthL.add(dec);        
        
        date = LocalDateTime.now();
        year = date.getYear();
        month = date.getMonthValue();
        monthT = new Text();
        monthT.setText(monthL.get(month - 1));
        monthT.setStyle("-fx-font-size: 30;");
        yearT = new Text(date.getYear() + "");
        yearT.setStyle("-fx-font-size: 30;");
        lBtn.setMinWidth(25);
        rBtn.setMinWidth(25);
        tBtn.setMinWidth(50);
        bMon.getChildren().addAll(monthT, yearT);
        bTop.getChildren().addAll(lBtn, tBtn, rBtn);
        bTop.setMinWidth(5);
        bTop.setPadding(new Insets(14, 20, 14, 20));
        bMain.setPadding(new Insets(20, 0, 5, 15));
        bMain.getChildren().addAll(bMon, bTop); 
        bMon.setAlignment(Pos.BASELINE_LEFT);
        bTop.setAlignment(Pos.BASELINE_RIGHT);
        
        containerPane.setTop(bMain);
        firstDay = 0;
        containerPane.setCenter(monthPane);
        mMonth = true;
        bMon.prefWidthProperty().bind(scene.widthProperty().multiply(0.50));
        bTop.prefWidthProperty().bind(scene.widthProperty().multiply(0.50));
        monthPane.prefWidthProperty().bind(scene.widthProperty().multiply(0.50));
        fillUpMonth();
       
        
        
    }
        
    public void fillUpMonth()
    {
        Text sT = new Text("Sunday");
        Text mT = new Text("Monday");
        Text tT = new Text("Tuesday");
        Text wT = new Text("Wendnesday");
        Text thT = new Text("Thursday");
        Text fT = new Text("Friday");
        Text saT = new Text("Saturday");        
        
        //set up initial variables
        int days = 0;
        today = date.getDayOfMonth();
        int daysMonthAfter = 0;
        int daysMonthBefore = 0;
        String dow = "";
        int dowI = 0;
             
        
        //find the first day of the month 
        if(month == 1){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now();
            localDate.now().withYear(year);
            localDate = LocalDate.now().withDayOfYear(1).withYear(year);
            dow = localDate.getDayOfWeek().toString();
        }else if(month == 2){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(32).withYear(year);
            dow = localDate.getDayOfWeek().toString();       
        }else if(month == 3){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(60).withYear(year);
            dow = localDate.getDayOfWeek().toString();      
        }else if(month == 4){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(91).withYear(year);
            dow = localDate.getDayOfWeek().toString();        
        }else if(month == 5){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(121).withYear(year);
            dow = localDate.getDayOfWeek().toString();        
        }else if(month == 6){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(152).withYear(year);
            dow = localDate.getDayOfWeek().toString();       
        }else if(month == 7){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(182).withYear(year);
            dow = localDate.getDayOfWeek().toString();       
        }else if(month == 8){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(213).withYear(year);
            dow = localDate.getDayOfWeek().toString();       
        }else if(month == 9){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(244).withYear(year);
            dow = localDate.getDayOfWeek().toString();       
        }else if(month == 10){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(274).withYear(year);
            dow = localDate.getDayOfWeek().toString();      
        }else if(month == 11){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now().withDayOfYear(305).withYear(year);
            dow = localDate.getDayOfWeek().toString();      
        }else if(month == 12){
            int dayOfYear = LocalDate.now().getDayOfYear();
            LocalDate localDate = LocalDate.now();
            localDate = LocalDate.now().withDayOfYear(335).withYear(year);
            dow = localDate.getDayOfWeek().toString();       
        }
        
        //convert the string day of the week of the first day of the month to a interger
        if(dow.matches("SUNDAY")){
            dowI = 0;
        }else if(dow.matches("MONDAY")){
            dowI = 1;
        }else if(dow.matches("TUESDAY")){
            dowI = 2;
        }else if(dow.matches("WEDNESDAY")){
            dowI = 3;
        }else if(dow.matches("THURSDAY")){
            dowI = 4;
        }else if(dow.matches("FRIDAY")){
            dowI = 5;
        }else if(dow.matches("SATURDAY")){
            dowI = 6;
        }        
              
        boolean leap;
        
        
        //find if leap year
        if((year % 4 == 0) && year % 100 != 0){
            leap = true;        
        }else if((year % 4 == 0) && (year % 100 == 0) && (year % 400 == 0)){
            leap = true;
        }else{
            leap = false;
        }
        
        //find number of days for current month
        if(month == 4 || month == 6 || month == 9 || month == 11){
            days = 30;
        }else if(month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12){
            days = 31;
        }else if(month == 2 && leap == true){
            days = 29;
        }else if(month == 2 && leap == false){
            days = 28;
        }
        
        
        //find number of days for previous month
        if(monthBefore == 4 || monthBefore == 6 || monthBefore == 9 || monthBefore == 11){
            daysMonthBefore = 30;
        }else if(monthBefore == 1 || monthBefore == 3 || monthBefore == 5 || monthBefore == 7 || monthBefore == 8 || monthBefore == 10 || monthBefore == 12){
            daysMonthBefore = 31;
        }else if(monthBefore == 2 && leap == true){
            daysMonthBefore = 29;
        }else if(monthBefore == 2 && leap == false){
            daysMonthBefore = 28;
        } 
        
        //find number of days for next month
        if(monthAfter == 4 || monthAfter == 6 || monthAfter == 9 || monthAfter == 11){
            daysMonthAfter= 30;
        }else if(monthAfter == 1 || monthAfter == 3 || monthAfter == 5 || monthAfter == 7 || monthAfter == 8 || monthAfter == 10 || monthAfter == 12){
            daysMonthAfter = 31;
        }else if(monthAfter == 2 && leap == true){
            daysMonthAfter = 29;
        }else if(monthAfter == 2 && leap == false){
            daysMonthAfter = 28;
        } 
       
       
       //check if the main month has started yet
       boolean startMon = false; 
       counter = 1;
       counter2 = daysMonthBefore - (dowI - 1);
       String s1 = "";
       String s2 = "";
       int days2 = 0;
      
        for(int r = 0; r < 8; r++){
            for(int c = 0; c < 8; c++){
                p1 = new StackPane();
                Text t2 = new Text();
                s1 = counter + "";
                s2 = counter2 + "";
                t1 = new Text(s1);
                t2 = new Text(s2);
               
                cToday = new Circle(20.5, Color.RED);
                                
                if(r == 0){
                    if(c == 0){
                        p1.setStyle("-fx-border-color: blue");
                        p1.setPadding(new Insets(10, 38, 10, 38));                   
                        p1.getChildren().add(sT);
                        p1.prefWidthProperty().bind(scene.widthProperty().divide(2));
                        p1.prefHeightProperty().bind(scene.heightProperty().divide(2));
                    }

                    if(c == 1){
                        p1.setStyle("-fx-border-color: blue");
                        p1.setPadding(new Insets(10, 38, 10, 38)); 
                        p1.prefWidthProperty().bind(scene.widthProperty().divide(2));
                        p1.prefHeightProperty().bind(scene.heightProperty().divide(2));                        
                        p1.getChildren().add(mT);
                    }

                    if(c == 2){
                        p1.setStyle("-fx-border-color: blue");
                        p1.setPadding(new Insets(10, 38, 10, 38));
                        p1.prefWidthProperty().bind(scene.widthProperty().divide(2));
                        p1.prefHeightProperty().bind(scene.heightProperty().divide(2));                        
                        p1.getChildren().add(tT);
                    }

                    if(c == 3){
                        p1.setStyle("-fx-border-color: blue");
                        p1.setPadding(new Insets(10, 38, 10, 38));
                        p1.prefWidthProperty().bind(scene.widthProperty().divide(2));
                        p1.prefHeightProperty().bind(scene.heightProperty().divide(2));                        
                        p1.getChildren().add(wT);
                    }

                    if(c == 4){
                        p1.setStyle("-fx-border-color: blue");
                        p1.setPadding(new Insets(10, 38, 10, 38));                    
                        p1.prefWidthProperty().bind(scene.widthProperty().divide(2));
                        p1.prefHeightProperty().bind(scene.heightProperty().divide(2));                        
                        p1.getChildren().add(thT);
                    }

                    if(c == 5){
                        p1.setStyle("-fx-border-color: blue");
                        p1.setPadding(new Insets(10, 38, 10, 38)); 
                        p1.prefWidthProperty().bind(scene.widthProperty().divide(2));
                        p1.prefHeightProperty().bind(scene.heightProperty().divide(2));                        
                        p1.getChildren().add(fT);
                    }

                    if(c == 6){
                        p1.setStyle("-fx-border-color: blue");
                        p1.setPadding(new Insets(10, 38, 10, 38));
                        p1.prefWidthProperty().bind(scene.widthProperty().divide(2));
                        p1.prefHeightProperty().bind(scene.heightProperty().divide(2));                        
                        p1.getChildren().add(saT);
                    }
                }else if(r <= 6 && c <= 6){
                        p1.setStyle("-fx-border-color: blue");
                        p1.prefWidthProperty().bind(scene.widthProperty().divide(2));
                        p1.prefHeightProperty().bind(scene.heightProperty().divide(2));                        
                        p1.setPadding(new Insets(33, 33, 33, 33)); 
                        
                        if(counter == today && mMonth == true && year == date.getYear()){
                            t1.setStroke(Color.WHITE);
                            
                            p1.getChildren().add(cToday);
                        }
                        
                        if(r == 1 && c == dowI || startMon == true){
                            
                            startMon = true;
                            if(r == 1){
                                days2++;
                            }
                            
                            if(counter < days){
                                p1.getChildren().add(t1);
                                counter++;

                                if(grey == true){
                                    t1.setFill(Color.GREY);
                                }
                            }else if(counter == days){
                                mMonth = false;
                                p1.getChildren().add(t1);
                                counter = 1;

                                grey = true;
                                
                            }
                        }else{                           
                            t2.setFill(Color.GREY);    
                            counter2++;
                            p1.getChildren().add(t2);
                        }
                }
                
                monthPane.add(p1, c, r);                
            }
        }      
        
        monthPane.setPadding(new Insets(0, 5, 5, 10));       

        //left button actions
        lBtn.setOnAction(e -> {
        
            //clear out previous month    
            for(int r = 0; r < 8; r++){
                for(int c = 0; c < 8; c++){
                    monthPane.getChildren().clear();               
                }                             
            }                   
                                 
            //check for yearly edge cases for main month
            if(month - 1 != 0){
                month = month - 1;
            }else{
                year--;
                month = 12;
            }           
  
            //set previous month
            if(month - 1 != 0){
                monthBefore = month - 1;
            }else{
                monthBefore = 12;
            }  
 
            //set next month
            if(month + 1 != 13){
                monthAfter = month + 1;
            }else{
                monthAfter = 1;
            }              
            
            //set text for proper  month and year
            monthT.setText(monthL.get(month - 1));
            yearT.setText(year + "");            
            
            today = date.getDayOfYear();
            grey = false;
            
            //check if this is the current month
            if(month == date.getMonthValue()){
                mMonth = true;
            }else{
                mMonth = false;
            }
                       
            
            fillUpMonth();
        });
        
        //right button actions
        rBtn.setOnAction(e -> {
         
            //clear out previous month    
            for(int r = 0; r < 8; r++){
                for(int c = 0; c < 8; c++){
                    monthPane.getChildren().clear();               
                }                             
            }                       
            
            //check for yearly edge cases
            if(month + 1 != 13){
                month = month + 1;
            }else{
                year++;
                month = 1;
            }
 
            //set previous month
            if(month - 1 != 0){
                monthBefore = month - 1;
            }else{
                monthBefore = 12;
            }  
 
            //set next month
            if(month + 1 != 13){
                monthAfter = month + 1;
            }else{
                monthAfter = 1;
            }              
            
            //set text for proper  month and year
            yearT.setText(year + "");
            monthT.setText(monthL.get(month - 1));
            grey = false;
            
            //check if this is the current month
            if(month == date.getMonthValue()){
                mMonth = true;
            }else{
                mMonth = false;
            }            
            
            fillUpMonth();
        }); 

        //click on date to set up appointment actions
        monthPane.setOnMouseClicked(e -> {
            setupAppointmentPane();
            appointmentStage.show();
        });

        //center button actions
        tBtn.setOnAction(e -> {
         
            //clear out previous month    
            for(int r = 0; r < 8; r++){
                for(int c = 0; c < 8; c++){
                    monthPane.getChildren().clear();               
                }                             
            }            
            year = date.getYear();
            month = date.getMonthValue();
            
            //set text for proper  month and year
            yearT.setText(year + "");
            monthT.setText(monthL.get(month - 1));
            mMonth = true;
            grey = false;

            fillUpMonth();
        });        
        
    }
    
    public void setupAppointmentPane()
    {
        //EXTRA CREDIT
        //TO BE COMPLETED AS REQUIRED IN THE INSTRUCTIONS
        appointmentPane.setPadding(new Insets(20));
        Text t1 = new Text("Title:");
        Text t2 = new Text("Time:");
        titleT = new TextField();
        Button clearBtn = new Button("Clear");
        Button submitBtn = new Button("Submit");
        
        //setup hours
        hr = new ComboBox<String>();
        for(int i = 0; i <= 23; i++){
            if(i < 10){
                String s1 = "0" + i;
                hr.getItems().add(s1);
            }else{
                hr.getItems().add(i + "");
            }
        }
        hr.getSelectionModel().select(date.getHour() + "");
        
        //setup minutes
        min = new ComboBox<String>();
        for(int i = 0; i <= 59; i++){
            if(i < 10){
                String s1 = "0" + i;
                min.getItems().add(s1);
            }else{
                min.getItems().add(i + "");
            }
        }
        min.getSelectionModel().select(date.getMinute());
        
        HBox h1 = new HBox(20);
        HBox h2 = new HBox(20);
        HBox h3 = new HBox(20);
        VBox v1 = new VBox(10);
        
        h1.getChildren().addAll(t1, titleT);
        h1.setAlignment(Pos.CENTER);
        h2.getChildren().addAll(t2, hr, min);
        h2.setAlignment(Pos.CENTER);
        h3.getChildren().addAll(clearBtn, submitBtn);
        h3.setAlignment(Pos.BASELINE_RIGHT);
        v1.getChildren().addAll(h1, h2, h3);
        
        appointmentPane.getChildren().addAll(v1);
        v1.setPadding(new Insets(50));
        
        clearBtn.setOnAction(e -> {
            clear();
        });       
        
    }
    
    public void displayAppointments()
    {
        //EXTRA CREDIT
        //TO BE COMPLETED AS REQUIRED IN THE INSTRUCTIONS
        
        
        
    }


    public void clear()
    {
        //EXTRA CREDIT
        //TO BE COMPLETED AS REQUIRED IN THE INSTRUCTIONS
        titleT.setText("");
        hr.getSelectionModel().select(date.getHour() + "");
        min.getSelectionModel().select(date.getMinute());        
        
        
    }

    public void storeAppointment()
    {   
        //EXTRA CREDIT
        //TO BE COMPLETED AS REQUIRED IN THE INSTRUCTIONS
        
        
        
        
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args)
    {
        launch(args);
    }
    
}
