/*
 * Decompiled with CFR 0.152.
 */
package colortrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Duration;

public class ColorTrapV2
extends Application {
    private Scene scene;
    private BorderPane borderPane;
    private Text txtCountDown = new Text();
    private Timeline timeline;
    private Timeline timeline2;
    private List<Color> colorA = new ArrayList<Color>();
    private List<Color> colorB = new ArrayList<Color>();
    private List<String> textA = new ArrayList<String>();
    private Text at0 = new Text();
    private Text at1 = new Text();
    private Text at2 = new Text();
    private Text at3 = new Text();
    private Text at4 = new Text();
    private Text at5 = new Text();
    private Text at6 = new Text();
    private Text scoreT;
    private HBox hbox;
    private HBox h1;
    private Button rest;
    private int scoreN;
    private boolean norm;
    private boolean hard;
    private final int SEC = 260;
    private CornerRadii r1 = new CornerRadii(0.0);
    private Color cLG = Color.LIGHTGRAY;
    private final int TIMER = 15;
    private int count = 0;
    private Text att2;

    public void start(Stage primaryStage) {
        this.borderPane = new BorderPane();
        Font.loadFont((String)"MarkerFelt.TTF", (double)10.0);
        this.borderPane.setStyle("-fx-background-color: lightgrey");
        this.scene = new Scene((Parent)this.borderPane, 600.0, 300.0);
        primaryStage.setMinHeight(300.0);
        primaryStage.setMinWidth(600.0);
        this.startScreen();
        primaryStage.setTitle("Color Trap");
        primaryStage.setScene(this.scene);
        primaryStage.show();
    }

    public void startScreen() {
        this.borderPane.setStyle("-fx-background-color: lightgrey");
        VBox vboxS = new VBox(10.0);
        HBox h1 = new HBox();
        Font mark = new Font("Marker Felt", 40.0);
        Text startText = new Text("Color Trap: The Game, The Game");
        Text verT = new Text("v1.3");
        startText.setFont(Font.font((String)"marker felt", (double)40.0));
        h1.getChildren().add((Object)startText);
        Button startBtn = new Button("Start Game");
        Button infoBtn = new Button("How to Play");
        vboxS.getChildren().addAll((Object[])new Node[]{startBtn, infoBtn});
        vboxS.setAlignment(Pos.CENTER);
        this.borderPane.setTop((Node)h1);
        h1.setAlignment(Pos.CENTER);
        this.borderPane.setCenter((Node)vboxS);
        this.borderPane.setBottom((Node)verT);
        startBtn.setOnAction(e -> this.chooseDif());
        infoBtn.setOnAction(e -> this.about());
    }

    public void chooseDif() {
        this.borderPane.setStyle("-fx-background-color: lightgrey");
        VBox vDif = new VBox(10.0);
        Text tDif = new Text("Choose Your Difficulty");
        Button normBtn = new Button("Normal");
        Button hardBtn = new Button("Hard");
        Button mainBtn = new Button("Main Menu");
        vDif.getChildren().addAll((Object[])new Node[]{tDif, normBtn, hardBtn, mainBtn});
        vDif.setAlignment(Pos.CENTER);
        this.borderPane.setCenter((Node)vDif);
        normBtn.setOnAction(e -> {
            this.norm = true;
            this.hard = false;
            this.borderPane.setStyle("-fx-background-color: lightgrey");
            this.initializeGame();
            this.startPlay();
        });
        hardBtn.setOnAction(e -> {
            this.hard = true;
            this.norm = false;
            this.initializeGame();
            this.startPlay();
        });
        mainBtn.setOnAction(e -> this.startScreen());
    }

    public void about() {
        this.borderPane.setStyle("-fx-background-color: lightgrey");
        VBox vAbout = new VBox(10.0);
        Text howT = new Text("How To Play:");
        Text howT3 = new Text("Click on the COLOR of the trap word displayed on top from the pool of words on the bottom.");
        Text howT4 = new Text("For example: if a trap word is YELLOW but its color is BLUE, you would select the word, not color, BLUE");
        Text howT6 = new Text("Normal Mode is 15 seconds with a solid background color");
        Text howT7 = new Text("Hard Mode is 15 seconds with a background that changes color every second.");
        Text howT8 = new Text("Good Luck!");
        Button mainBtn = new Button("Main Menu");
        Button startBtn = new Button("Start Game");
        vAbout.getChildren().addAll((Object[])new Node[]{howT, howT3, howT4, howT6, howT7, howT8, mainBtn, startBtn});
        vAbout.setAlignment(Pos.CENTER);
        this.borderPane.setCenter((Node)vAbout);
        mainBtn.setOnAction(e -> this.startScreen());
        startBtn.setOnAction(e -> this.chooseDif());
    }

    public void startPlay() {
        this.chooseTrapWordAndColor();
        this.colorNameOptions();
        Color cP = Color.PINK;
        Color cB = Color.BEIGE;
        Color cBW = Color.BURLYWOOD;
        Color cC = Color.CYAN;
        Color cG = Color.GOLD;
        Color cL = Color.LAVENDER;
        this.colorB.add(cP);
        this.colorB.add(cB);
        this.colorB.add(cBW);
        this.colorB.add(cC);
        this.colorB.add(cG);
        this.colorB.add(cL);
        this.count = 15;
        this.txtCountDown.setText("15");
        if (this.hard) {
            this.timeline2 = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)260.0), e -> {
                Random rnd = new Random();
                Collections.shuffle(this.colorB, rnd);
                if (this.count >= 0) {
                    Color res = this.colorB.get(0);
                    this.borderPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)res, this.r1, new Insets(0.0))}));
                } else {
                    Duration.millis((double)0.0);
                    this.borderPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.cLG, this.r1, new Insets(0.0))}));
                    this.timeline2.stop();
                }
            }, new KeyValue[0])});
            this.timeline2.setCycleCount(999);
            this.timeline2.play();
        }
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), e -> {
            if (this.count >= 0) {
                this.txtCountDown.setText(this.count + "");
                --this.count;
            } else {
                this.borderPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.cLG, this.r1, new Insets(0.0))}));
                this.endOfGame();
                this.timeline.stop();
            }
        }, new KeyValue[0])});
        this.timeline.setCycleCount(17);
        this.timeline.play();
    }

    public void endOfGame() {
        Font mark = new Font("Marker Felt", 20.0);
        this.at0.setText("");
        this.at1.setText("");
        this.at2.setText("");
        this.at3.setText("");
        this.at4.setText("");
        this.at5.setText("");
        this.at6.setText("");
        this.att2.setText("");
        this.hbox.setOpacity(0.0);
        VBox vbox = new VBox(25.0);
        vbox.setPadding(new Insets(0.0, 0.0, 200.0, 0.0));
        Text endT = new Text("Your score: " + this.scoreN);
        Button changDifBtn = new Button("Change Diffculity");
        Button mainBtn = new Button("Main Menu");
        endT.setFont(mark);
        vbox.setAlignment(Pos.CENTER);
        this.rest.setDisable(false);
        vbox.getChildren().addAll((Object[])new Node[]{endT, this.rest, changDifBtn, mainBtn});
        this.borderPane.setCenter((Node)vbox);
        this.rest.setOnAction(e -> {
            this.startPlay();
            this.hbox.setOpacity(1.0);
            this.scoreN = 0;
            this.scoreT.setText("Score: " + this.scoreN);
        });
        changDifBtn.setOnAction(e -> this.chooseDif());
        mainBtn.setOnAction(e -> this.startScreen());
    }

    public void checkChoice(Text choice) {
        if (this.att2.getFill().toString().equals("0xffff00ff") && choice.getText().equals("Yellow")) {
            ++this.scoreN;
            this.scoreT.setText("Score: " + this.scoreN + " ");
        } else if (this.att2.getFill().toString().equals("0xa52a2aff") && choice.getText().equals("Brown")) {
            ++this.scoreN;
            this.scoreT.setText("Score: " + this.scoreN + " ");
        } else if (this.att2.getFill().toString().equals("0x0000ffff") && choice.getText().equals("Blue")) {
            ++this.scoreN;
            this.scoreT.setText("Score: " + this.scoreN + " ");
        } else if (this.att2.getFill().toString().equals("0x000000ff") && choice.getText().equals("Black")) {
            ++this.scoreN;
            this.scoreT.setText("Score: " + this.scoreN + " ");
        } else if (this.att2.getFill().toString().equals("0xff0000ff") && choice.getText().equals("Red")) {
            ++this.scoreN;
            this.scoreT.setText("Score: " + this.scoreN + " ");
        } else if (this.att2.getFill().toString().equals("0x800080ff") && choice.getText().equals("Purple")) {
            ++this.scoreN;
            this.scoreT.setText("Score: " + this.scoreN + " ");
        } else if (this.att2.getFill().toString().equals("0xffa500ff") && choice.getText().equals("Orange")) {
            ++this.scoreN;
            this.scoreT.setText("Score: " + this.scoreN + " ");
        }
        this.chooseTrapWordAndColor();
        this.colorNameOptions();
    }

    public void chooseTrapWordAndColor() {
        this.h1 = new HBox();
        this.h1.prefHeightProperty().bind((ObservableValue)this.scene.heightProperty().multiply(0.35));
        this.att2 = new Text(this.textA.get(0));
        Font mark = new Font("Marker Felt", 60.0);
        this.att2.setFill((Paint)this.colorA.get(0));
        this.att2.setFont(mark);
        this.h1.getChildren().add((Object)this.att2);
        this.borderPane.setTop((Node)this.h1);
        this.h1.setAlignment(Pos.CENTER);
    }

    public void colorNameOptions() {
        Random rnd = new Random();
        Collections.shuffle(this.textA, rnd);
        Collections.shuffle(this.colorA, rnd);
        FlowPane fPane = new FlowPane(Orientation.VERTICAL);
        fPane.setHgap(20.0);
        fPane.setVgap(0.0);
        Font mark2 = new Font("Marker Felt", 40.0);
        this.at0 = new Text(this.textA.get(0));
        this.at1 = new Text(this.textA.get(1));
        this.at2 = new Text(this.textA.get(2));
        this.at3 = new Text(this.textA.get(3));
        this.at4 = new Text(this.textA.get(4));
        this.at5 = new Text(this.textA.get(5));
        this.at6 = new Text(this.textA.get(6));
        this.at0.setFill((Paint)this.colorA.get(0));
        this.at1.setFill((Paint)this.colorA.get(1));
        this.at2.setFill((Paint)this.colorA.get(2));
        this.at3.setFill((Paint)this.colorA.get(3));
        this.at4.setFill((Paint)this.colorA.get(4));
        this.at5.setFill((Paint)this.colorA.get(5));
        this.at6.setFill((Paint)this.colorA.get(6));
        this.at0.setFont(mark2);
        this.at1.setFont(mark2);
        this.at2.setFont(mark2);
        this.at3.setFont(mark2);
        this.at4.setFont(mark2);
        this.at5.setFont(mark2);
        this.at6.setFont(mark2);
        fPane.getChildren().addAll((Object[])new Node[]{this.at0, this.at1, this.at2, this.at3, this.at4, this.at5, this.at6});
        this.borderPane.setCenter((Node)fPane);
        fPane.setAlignment(Pos.CENTER);
        this.at0.setOnMouseClicked(e -> this.checkChoice(this.at0));
        this.at1.setOnMouseClicked(e -> this.checkChoice(this.at1));
        this.at2.setOnMouseClicked(e -> this.checkChoice(this.at2));
        this.at3.setOnMousePressed(e -> this.checkChoice(this.at3));
        this.at4.setOnMousePressed(e -> this.checkChoice(this.at4));
        this.at5.setOnMousePressed(e -> this.checkChoice(this.at5));
        this.at6.setOnMousePressed(e -> this.checkChoice(this.at6));
    }

    public void initializeGame() {
        this.borderPane.setStyle("-fx-background-color: lightgrey");
        this.hbox = new HBox(20.0);
        this.scoreN = 0;
        this.scoreT = new Text("Score: " + this.scoreN);
        Text timer = new Text("Time Remaining: ");
        this.scoreT.setFont(Font.font((double)20.0));
        timer.setFont(Font.font((double)20.0));
        this.txtCountDown.setFont(Font.font((double)20.0));
        this.colorA = new ArrayList<Color>();
        this.colorB = new ArrayList<Color>();
        this.textA = new ArrayList<String>();
        this.hbox.getChildren().addAll((Object[])new Node[]{this.scoreT, timer, this.txtCountDown});
        this.borderPane.setBottom((Node)this.hbox);
        this.hbox.setOpacity(1.0);
        this.rest = new Button("Play again");
        this.rest.setDisable(true);
        Font mark2 = new Font("Marker Felt", 40.0);
        FlowPane fPane = new FlowPane(Orientation.VERTICAL);
        String or = "Orange";
        String br = "Brown";
        String ye = "Yellow";
        String bu = "Blue";
        String re = "Red";
        String bl = "Black";
        String pu = "Purple";
        Color cOr = Color.ORANGE;
        Color cBr = Color.BROWN;
        Color cYe = Color.YELLOW;
        Color cBu = Color.BLUE;
        Color cRe = Color.RED;
        Color cBl = Color.BLACK;
        Color cPu = Color.PURPLE;
        this.colorA.add(cOr);
        this.colorA.add(cBr);
        this.colorA.add(cYe);
        this.colorA.add(cBu);
        this.colorA.add(cRe);
        this.colorA.add(cBl);
        this.colorA.add(cPu);
        this.textA.add(or);
        this.textA.add(br);
        this.textA.add(ye);
        this.textA.add(bu);
        this.textA.add(re);
        this.textA.add(bl);
        this.textA.add(pu);
        fPane.setHgap(20.0);
        fPane.setVgap(0.0);
        this.at0 = new Text(this.textA.get(0));
        this.at1 = new Text(this.textA.get(1));
        this.at2 = new Text(this.textA.get(2));
        this.at3 = new Text(this.textA.get(3));
        this.at4 = new Text(this.textA.get(4));
        this.at5 = new Text(this.textA.get(5));
        this.at6 = new Text(this.textA.get(6));
        this.at0.setFill((Paint)this.colorA.get(0));
        this.at1.setFill((Paint)this.colorA.get(1));
        this.at2.setFill((Paint)this.colorA.get(2));
        this.at3.setFill((Paint)this.colorA.get(3));
        this.at4.setFill((Paint)this.colorA.get(4));
        this.at5.setFill((Paint)this.colorA.get(5));
        this.at6.setFill((Paint)this.colorA.get(6));
        this.at0.setFont(mark2);
        this.at1.setFont(mark2);
        this.at2.setFont(mark2);
        this.at3.setFont(mark2);
        this.at4.setFont(mark2);
        this.at5.setFont(mark2);
        this.at6.setFont(mark2);
        fPane.setAlignment(Pos.CENTER);
        fPane.getChildren().addAll((Object[])new Node[]{this.at0, this.at1, this.at2, this.at3, this.at4, this.at5, this.at6});
        fPane.prefHeightProperty().bind((ObservableValue)this.scene.heightProperty().multiply(0.55));
        this.hbox.prefHeightProperty().bind((ObservableValue)this.scene.heightProperty().multiply(0.1));
    }

    public static void main(String[] args) {
        ColorTrapV2.launch((String[])args);
    }
}

