package colortrap;

import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.*;
import javafx.scene.text.*;
import javafx.util.Duration;
import javafx.geometry.Pos;
import javafx.geometry.Insets;
import javafx.scene.shape.*;
import java.util.Arrays;
import java.util.*;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.scene.paint.Color;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;


public class ColorTrapV2 extends Application
{
    private Scene scene;
    private BorderPane borderPane;
    private Text txtCountDown = new Text();
    private Timeline timeline;
    private Timeline timeline2;
    private List <Color> colorA = new ArrayList();
    private List <Color> colorB = new ArrayList();
    private List <String> textA = new ArrayList();
    private Text at0 = new Text();
    private Text at1 = new Text();
    private Text at2 = new Text();
    private Text at3 = new Text();
    private Text at4 = new Text();
    private Text at5 = new Text();
    private Text at6 = new Text();
    private Text scoreT;
    private HBox hbox;
    private HBox h1;
    private Button rest;
    private int scoreN;
    private boolean norm;
    private boolean hard;
    private final int SEC = 260;
    private CornerRadii r1 = new CornerRadii(0);
    private Color cLG = Color.LIGHTGRAY;

    private final int TIMER = 15;
    private int count = 0;
    private Text att2;

    @Override
    public void start(Stage primaryStage)
    {
        borderPane = new BorderPane();
        Font.loadFont(("MarkerFelt.TTF"), 10);
        borderPane.setStyle("-fx-background-color: lightgrey");
        scene = new Scene(borderPane, 600, 300);
        primaryStage.setMinHeight(300);
        primaryStage.setMinWidth(600);
        startScreen();
        primaryStage.setTitle("Color Trap");
        primaryStage.setScene(scene);
        primaryStage.show();
    }
  
    public void startScreen(){
        borderPane.setStyle("-fx-background-color: lightgrey");
        VBox vboxS = new VBox(10);
        HBox h1 = new HBox();
        Font mark = new Font("Marker Felt", 40); 
        Text startText = new Text("Color Trap: The Game, The Game");
        Text verT = new Text("v1.3");            
        startText.setFont(Font.font("marker felt", 40));
        h1.getChildren().add(startText);
        Button startBtn = new Button("Start Game");
        Button infoBtn = new Button("How to Play");
        vboxS.getChildren().addAll(startBtn, infoBtn);
        vboxS.setAlignment(Pos.CENTER);
        borderPane.setTop(h1);
        h1.setAlignment(Pos.CENTER);
        borderPane.setCenter(vboxS);
        borderPane.setBottom(verT);
        
        startBtn.setOnAction(e -> {
            chooseDif();
        });
        
        infoBtn.setOnAction(e -> {
            about();
        });
    }
    
    public void chooseDif(){
        borderPane.setStyle("-fx-background-color: lightgrey");
        
        VBox vDif = new VBox(10);
        
        Text tDif = new Text("Choose Your Difficulty");
        
        Button normBtn = new Button("Normal");
        Button hardBtn = new Button("Hard");
        Button mainBtn = new Button("Main Menu");
        
        vDif.getChildren().addAll(tDif, normBtn, hardBtn, mainBtn);
        vDif.setAlignment(Pos.CENTER);        
        
        borderPane.setCenter(vDif);
        
        normBtn.setOnAction(e -> {
           norm = true;
           hard = false;
           borderPane.setStyle("-fx-background-color: lightgrey");
           initializeGame();
           startPlay();
        });
        
        hardBtn.setOnAction(e -> {
           hard = true;
           norm = false;
           initializeGame();
           startPlay();
        });
        
        mainBtn.setOnAction(e -> {
            startScreen();
        });
    }
    
    public void about(){
        borderPane.setStyle("-fx-background-color: lightgrey");
        VBox vAbout = new VBox(10);
        
        
        Text howT = new Text("How To Play:");
        Text howT3 = new Text("Click on the COLOR of the trap word displayed on top from the pool of words on the bottom.");
        Text howT4 = new Text("For example: if a trap word is YELLOW but its color is BLUE, you would select the word, not color, BLUE");
        Text howT6 = new Text("Normal Mode is 15 seconds with a solid background color");
        Text howT7 = new Text("Hard Mode is 15 seconds with a background that changes color every second.");
        Text howT8 = new Text("Good Luck!");
        
        Button mainBtn = new Button("Main Menu");
        Button startBtn = new Button("Start Game");
        
        vAbout.getChildren().addAll(howT, howT3, howT4, howT6, howT7, howT8, mainBtn, startBtn);
        vAbout.setAlignment(Pos.CENTER);
        borderPane.setCenter(vAbout);      
        
        mainBtn.setOnAction(e -> {
            startScreen();
        });
        
        startBtn.setOnAction(e -> {
            chooseDif();
        });
    }
    
    public void startPlay()
    {
        chooseTrapWordAndColor();
        colorNameOptions();
        
        Color cP = Color.PINK;
        Color cB = Color.BEIGE;
        Color cBW = Color.BURLYWOOD;
        Color cC = Color.CYAN;
        Color cG = Color.GOLD;
        Color cL = Color.LAVENDER;
        
        colorB.add(cP);
        colorB.add(cB);
        colorB.add(cBW);
        colorB.add(cC);
        colorB.add(cG);
        colorB.add(cL);
        
        count = TIMER;
        txtCountDown.setText(TIMER + "");
        
        if(hard){
        timeline2 = new Timeline(new KeyFrame(
                Duration.millis(SEC), e -> {
                Random rnd = new Random();
                Collections.shuffle(colorB, rnd);
                    if(count >= 0){
                        Color res = colorB.get(0);
                        borderPane.setBackground(new Background(new BackgroundFill(res, r1, new Insets(0))));
                    }else{
                        Duration.millis(0);
                        borderPane.setBackground(new Background(new BackgroundFill(cLG, r1, new Insets(0))));
                        timeline2.stop();
                    }
                }
                
        ));
        timeline2.setCycleCount(999);
        timeline2.play();  
        
        }
               
        timeline = new Timeline(new KeyFrame(
                Duration.millis(1000), e -> {

                    if(count >= 0)
                    {
                        txtCountDown.setText(count + "");
                        count--;
                    }
                    else
                    {
                        borderPane.setBackground(new Background(new BackgroundFill(cLG, r1, new Insets(0))));
                        endOfGame();
                        timeline.stop();
                    }
                }));
        timeline.setCycleCount(TIMER + 2);
        timeline.play();
    }
    
    public void endOfGame()
    {
        Font mark = new Font("Marker Felt", 20);
        at0.setText("");
        at1.setText("");
        at2.setText("");
        at3.setText("");
        at4.setText("");
        at5.setText("");
        at6.setText("");
        att2.setText("");
        hbox.setOpacity(0);
        VBox vbox = new VBox(25);
        vbox.setPadding(new Insets(0, 0, 200, 0));
        Text endT = new Text("Your score: " + scoreN);
        Button changDifBtn = new Button("Change Diffculity");
        Button mainBtn = new Button("Main Menu");
        endT.setFont(mark);
        vbox.setAlignment(Pos.CENTER);
        
        rest.setDisable(false);
        vbox.getChildren().addAll(endT, rest, changDifBtn, mainBtn);
        borderPane.setCenter(vbox);
        
        rest.setOnAction(e -> {
            startPlay();
            hbox.setOpacity(1);
            scoreN = 0;
            scoreT.setText("Score: " + scoreN);
        });  
        
        changDifBtn.setOnAction(e -> {
           chooseDif(); 
        });
        
        mainBtn.setOnAction(e -> {
            startScreen();
        });
    }


    public void checkChoice(Text choice)
    {
        if(att2.getFill().toString().equals("0xffff00ff") && choice.getText().equals("Yellow")){
            scoreN++;
            scoreT.setText("Score: " + scoreN + " ");
        }else if(att2.getFill().toString().equals("0xa52a2aff") && choice.getText().equals("Brown")){
            scoreN++;
            scoreT.setText("Score: " + scoreN + " ");
        }else if(att2.getFill().toString().equals("0x0000ffff") && choice.getText().equals("Blue")){
            scoreN++;
            scoreT.setText("Score: " + scoreN + " ");
        }else if(att2.getFill().toString().equals("0x000000ff") && choice.getText().equals("Black")){
            scoreN++;
            scoreT.setText("Score: " + scoreN + " ");
        }else if(att2.getFill().toString().equals("0xff0000ff") && choice.getText().equals("Red")){
            scoreN++;
            scoreT.setText("Score: " + scoreN + " ");
        }else if(att2.getFill().toString().equals("0x800080ff") && choice.getText().equals("Purple")){
            scoreN++;
            scoreT.setText("Score: " + scoreN + " ");
        }else if(att2.getFill().toString().equals("0xffa500ff") && choice.getText().equals("Orange")){
            scoreN++;
            scoreT.setText("Score: " + scoreN + " ");
        }
        //Do NOT add any code after this comment
        //Choose a new trap word and options list
        chooseTrapWordAndColor();
        colorNameOptions();
    }

    public void chooseTrapWordAndColor()
    {       
            h1 = new HBox();
            h1.prefHeightProperty().bind(scene.heightProperty().multiply(0.35));            
            att2 = new Text(textA.get(0));
            Font mark = new Font("Marker Felt", 60);           
            att2.setFill(colorA.get(0));
            att2.setFont(mark);  
            h1.getChildren().add(att2);          
            borderPane.setTop(h1);
            h1.setAlignment(Pos.CENTER);
    }
    
    public void colorNameOptions()
    {         
        Random rnd = new Random();
        Collections.shuffle(textA, rnd);
        Collections.shuffle(colorA, rnd);       
        FlowPane fPane = new FlowPane(Orientation.VERTICAL);
        fPane.setHgap(20);
        fPane.setVgap(0);
        
        Font mark2 = new Font("Marker Felt", 40);
        
        at0 = new Text(textA.get(0));
        at1 = new Text(textA.get(1));
        at2 = new Text(textA.get(2));
        at3 = new Text(textA.get(3));
        at4 = new Text(textA.get(4));
        at5 = new Text(textA.get(5));
        at6 = new Text(textA.get(6));
 
        at0.setFill(colorA.get(0));
        at1.setFill(colorA.get(1));
        at2.setFill(colorA.get(2));
        at3.setFill(colorA.get(3));
        at4.setFill(colorA.get(4));
        at5.setFill(colorA.get(5));
        at6.setFill(colorA.get(6));

        at0.setFont(mark2);
        at1.setFont(mark2);
        at2.setFont(mark2);
        at3.setFont(mark2);
        at4.setFont(mark2);
        at5.setFont(mark2);
        at6.setFont(mark2); 
                        
        fPane.getChildren().addAll(at0, at1, at2, at3, at4 ,at5 ,at6);               
        borderPane.setCenter(fPane);
        fPane.setAlignment(Pos.CENTER);
        
        at0.setOnMouseClicked(e -> {           
            checkChoice(at0);
        });
        
        at1.setOnMouseClicked(e -> {
            checkChoice(at1);
        });
        
        at2.setOnMouseClicked(e -> {
             checkChoice(at2); 
        });
        
        at3.setOnMousePressed(e -> {
             checkChoice(at3); 
        });
        
        at4.setOnMousePressed(e -> {
             checkChoice(at4);
        });
        
        at5.setOnMousePressed(e -> {
            checkChoice(at5); 
        });
        
        at6.setOnMousePressed(e -> {
            checkChoice(at6); 
        });        
    }

    public void initializeGame()
    {
        borderPane.setStyle("-fx-background-color: lightgrey");
        hbox = new HBox(20);
        scoreN = 0;
        scoreT = new Text("Score: " + scoreN);
        Text timer = new Text("Time Remaining: " );
        scoreT.setFont(Font.font(20));
        timer.setFont(Font.font(20));
        txtCountDown.setFont(Font.font(20));

        colorA = new ArrayList();
        colorB = new ArrayList();
        textA = new ArrayList();        
        
        hbox.getChildren().addAll(scoreT, timer, txtCountDown);

        borderPane.setBottom(hbox);
        hbox.setOpacity(1);
        rest = new Button("Play again");
        rest.setDisable(true);
        Font mark2 = new Font("Marker Felt", 40);
        
        FlowPane fPane = new FlowPane(Orientation.VERTICAL);      
        
        String or = "Orange";
        String br = "Brown";
        String ye = "Yellow";
        String bu = "Blue";
        String re = "Red";
        String bl = "Black";
        String pu = "Purple";
       
        Color cOr = Color.ORANGE;
        Color cBr = Color.BROWN;
        Color cYe = Color.YELLOW;
        Color cBu = Color.BLUE;
        Color cRe = Color.RED;
        Color cBl = Color.BLACK;
        Color cPu = Color.PURPLE;        
        
        colorA.add(cOr);
        colorA.add(cBr);
        colorA.add(cYe);
        colorA.add(cBu);
        colorA.add(cRe);
        colorA.add(cBl);
        colorA.add(cPu);
                
        textA.add(or);
        textA.add(br);
        textA.add(ye);
        textA.add(bu);
        textA.add(re);
        textA.add(bl);
        textA.add(pu);      
 
        fPane.setHgap(20);
        fPane.setVgap(0);
                    
        at0 = new Text(textA.get(0));
        at1 = new Text(textA.get(1));
        at2 = new Text(textA.get(2));
        at3 = new Text(textA.get(3));
        at4 = new Text(textA.get(4));
        at5 = new Text(textA.get(5));
        at6 = new Text(textA.get(6));
 
        at0.setFill(colorA.get(0));
        at1.setFill(colorA.get(1));
        at2.setFill(colorA.get(2));
        at3.setFill(colorA.get(3));
        at4.setFill(colorA.get(4));
        at5.setFill(colorA.get(5));
        at6.setFill(colorA.get(6));

        at0.setFont(mark2);
        at1.setFont(mark2);
        at2.setFont(mark2);
        at3.setFont(mark2);
        at4.setFont(mark2);
        at5.setFont(mark2);
        at6.setFont(mark2);
        
        fPane.setAlignment(Pos.CENTER);
        fPane.getChildren().addAll(at0, at1, at2, at3, at4 ,at5 ,at6);
        fPane.prefHeightProperty().bind(scene.heightProperty().multiply(0.55));
        hbox.prefHeightProperty().bind(scene.heightProperty().multiply(0.10));
    }
    public static void main(String[] args)
    {
        launch(args);
    }
}