/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package militarydb;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
/**
 *
 * @author Mike
 */
public class DBOps {
    private static List <User> userList = new ArrayList();
    private static List <Weapon>weaponList = new ArrayList();
    private static List <Patrol>patrolList = new ArrayList();
    private static List <Area>areaList = new ArrayList();
    private static List <AreaRep>areaRepList = new ArrayList();
    
    private static User user;
    private static Weapon weapon;
    private static Patrol patrol;
    private static Area area;
    private static AreaRep areaRep;
    
    public static void main(String[] args){
        try{
            Connect.getConnection();
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }

    //checks entered name and password in login screen against user entires in database
    public static int checkUser(String userN, String userP) throws SQLException{
        String sql = "SELECT * FROM UserInfo WHERE userName = '"+ userN +"' and userPass = sha('"+ userP +"')";
        int count = 0;
        try{
            Statement statement = Connect.getConnection().createStatement();
            ResultSet result = statement.executeQuery(sql);

            while(result.next()){
                count++;
            }
            return count;
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return count;
    } 
    
    //User based DB Operations
    public static int insertUserEntry(String name, String pass, String rank, String SSN, String DOB) throws SQLException {
        String sql = "INSERT INTO UserInfo(userID, userName, userPass, userRank, SSN, DOB)"
                     + "VALUES(uuid(),?, sha(?), ?, ?, ?)";
        int res = 0;
        
        try{
        PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
        statement.setString(1, name);
        statement.setString(2, pass);
        statement.setString(3, rank);
        statement.setString(4, SSN);
        statement.setString(5, DOB);
        
        int rowsAffected = statement.executeUpdate();
        if(rowsAffected > 0){
            res++;
        }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return res;
    }

    public static int deleteUserEntry(String id) throws SQLException {
        String sql = "DELETE FROM UserInfo WHERE userID='"+ id +"'";
        int res = 0;
        
        try{
           PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
           int affected = statement.executeUpdate();
           
           if(affected > 0){
               res++;
           }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return res;
    }

    public static List selectUserEntries() throws SQLException{
        String sql = "SELECT userID, userName, userPass, userRank, weaponID, patrolID, timeInService, SSN, DOB, patrolName, weaponName FROM UserInfo "
                + "LEFT JOIN Weapons ON userInfo.userID = weapons.assignedTo "
                + "LEFT JOIN Patrol ON userInfo.userID = patrol.assignedUser";
        try{
            Statement statement = Connect.getConnection().createStatement();
            ResultSet result = statement.executeQuery(sql);
            int count = 0;
            
            while(result.next()){
                String uID = result.getString(1);
                String uN = result.getString(2);
                String uP = result.getString(3);
                String uR = result.getString(4);
                String uAW = result.getString(5);
                String uAP = result.getString(6);
                String uTIS = result.getString(7);
                String uSSN = result.getString(8);
                String uDOB = result.getString(9);
                String uPN = result.getString(10);
                String uWN = result.getString(11);
                user = new User(uID, uN, uP, uR, uAW, uAP, uTIS, uSSN, uDOB, uPN, uWN);
                userList.add(user);                
            }
            return userList;
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return userList;
    }

    public static int updateUser(String id, String name, String pass, String rank, String SSN, String DOB) throws SQLException {
            String sql = "UPDATE UserInfo SET userName=?, userPass=sha(?), userRank=?, SSN=?, DOB=? WHERE userID = '"+ id +"'";
            int count = 0;
            try{
                PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
                statement.setString(1, name);
                statement.setString(2, pass);
                statement.setString(3, rank);
                statement.setString(4, SSN);
                statement.setString(5, DOB);

                count = statement.executeUpdate();
                
            }catch(Exception ex){
                ex.printStackTrace();
            }
            return count;        
        }

        
    //Weapon based DB Operations
    public static int insertWeaponEntry(String con, String aT, String name) throws SQLException {
        String sql = "INSERT INTO Weapons(weaponID, conditionStatus, assignedTo, weaponName)"
                     + "VALUES(uuid(), ?, ?, ?)";
        
        int res = 0;
        try{
        PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
        statement.setString(1, con);
        statement.setString(2, aT);
        statement.setString(3, name);

        
        int rowsAffected = statement.executeUpdate();
        if(rowsAffected > 0){
            res++;
        }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return res;
    }           
    
    public static List selectWeaponEntries() throws SQLException{
        String sql = "SELECT weaponID, conditionStatus, assignedTo, weaponName, userName FROM Weapons LEFT JOIN UserInfo ON weapons.assignedTo = userInfo.userID";
        try{
            Statement statement = Connect.getConnection().createStatement();
            ResultSet result = statement.executeQuery(sql);
            int count = 0;
            
            while(result.next()){
                String wID = result.getString(1);
                String wCS = result.getString(2);
                String wAT = result.getString(3);
                String wW = result.getString(4);
                String wUN = result.getString(5);
                weapon = new Weapon(wID, wCS, wW, wAT, wUN);
                weaponList.add(weapon);               
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return weaponList;
    }    
                   
    public static int updateWeapon(String id, String con, String aT, String name) throws SQLException {
            String sql = "UPDATE Weapons SET conditionStatus=?, assignedTo=?, weaponName=? WHERE weaponID = '"+ id +"'";
            int count = 0;
            try{
                PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
                statement.setString(1, con);
                statement.setString(2, aT);
                statement.setString(3, name);

                count = statement.executeUpdate();
                
            }catch(Exception ex){
                ex.printStackTrace();
            }
            return count;        
        }  
        
    public static int deleteWeaponEntry(String id) throws SQLException {
        String sql = "DELETE FROM Weapons WHERE weaponID='"+ id +"'";
        int res = 0;
        
        try{
           PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
           int affected = statement.executeUpdate();
           
           if(affected > 0){
               res++;
           }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return res;
    }
    
    //Patrol based DB Operations
    public static int insertPatrolEntry(String name, String user, String area, String duration) throws SQLException {
        String sql = "INSERT INTO Patrol(patrolID, patrolName, assignedUser, assignedArea, duration)"
                     + "VALUES(uuid(), ?, ?, ?, ?)";
        
        int res = 0;
        try{
        PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
        statement.setString(1, name);
        statement.setString(2, user);
        statement.setString(3, area);
        statement.setString(4, duration);

        
        int rowsAffected = statement.executeUpdate();
        if(rowsAffected > 0){
            res++;
        }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return res;
    }           
    
    public static List selectPatrolEntries() throws SQLException{
        String sql = "SELECT patrolID, patrolName, assignedUser, assignedArea, duration, userName, areaName FROM Patrol LEFT JOIN userinfo on patrol.assignedUser = userinfo.userid LEFT JOIN areaInfo on patrol.assignedArea = areaInfo.areaID";
        try{
            Statement statement = Connect.getConnection().createStatement();
            ResultSet result = statement.executeQuery(sql);
            int count = 0;
            
            while(result.next()){
                String pID = result.getString(1);
                String pN = result.getString(2);
                String pAU = result.getString(3);
                String pAA = result.getString(4);
                String pD = result.getString(5);
                String pUN = result.getString(6);
                String pAN = result.getString(7);
                patrol = new Patrol(pID, pN, pAU, pAA, pD, pUN, pAN);
                patrolList.add(patrol);               
            }
            return patrolList;
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return patrolList;
    }    
                   
    public static int updatePatrol(String id, String name, String au, String aa, String dur) throws SQLException {
            String sql = "UPDATE Patrol SET patrolName=?, assignedUser=?, assignedArea=?, duration=? WHERE patrolID = '"+ id +"'";
            int count = 0;
            try{
                PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
                statement.setString(1, name);
                statement.setString(2, au);
                statement.setString(3, aa);
                statement.setString(4, dur);

                count = statement.executeUpdate();
                
            }catch(Exception ex){
                ex.printStackTrace();
            }
            return count;        
        }  
        
    public static int deletePatrolEntry(String id) throws SQLException {
        String sql = "DELETE FROM Patrol WHERE patrolID='"+ id +"'";
        int res = 0;
        
        try{
           PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
           int affected = statement.executeUpdate();
           
           if(affected > 0){
               res++;
           }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return res;
    }      
 
    //Area based DB Operations
    public static int insertAreaEntry(String name, String level) throws SQLException {
        String sql = "INSERT INTO AreaInfo(areaID, areaName, securityLevel)"
                     + "VALUES(uuid(), ?, ?)";
        
        int res = 0;
        try{
        PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
        statement.setString(1, name);
        statement.setString(2, level);
        
        int rowsAffected = statement.executeUpdate();
        if(rowsAffected > 0){
            res++;
        }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return res;
    }           
    
    public static List selectAreaEntries() throws SQLException{
        String sql = "SELECT * FROM AreaInfo";
        try{
            Statement statement = Connect.getConnection().createStatement();
            ResultSet result = statement.executeQuery(sql);
            int count = 0;
            
            while(result.next()){
                String aID = result.getString(1);
                String aN = result.getString(2);
                String aSL = result.getString(3);
                area = new Area(aID, aSL, aN);
                areaList.add(area);               
            }
            return areaList;
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return areaList;
    }    
                   
    public static int updateArea(String id, String name, String level) throws SQLException {
            String sql = "UPDATE AreaInfo SET areaName=?, securityLevel=? WHERE areaID = '"+ id +"'";
            int count = 0;
            try{
                PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
                statement.setString(1, name);
                statement.setString(2, level);

                count = statement.executeUpdate();
                
            }catch(Exception ex){
                ex.printStackTrace();
            }
            return count;        
        }  
        
    public static int deleteAreaEntry(String id) throws SQLException {
        String sql = "DELETE FROM AreaInfo WHERE areaID='"+ id +"'";
        int res = 0;
        
        try{
           PreparedStatement statement = Connect.getConnection().prepareStatement(sql);
           int affected = statement.executeUpdate();
           
           if(affected > 0){
               res++;
           }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return res;
    }       

    //Area Report based DB Operations
    
    public static List selectAreaRepEntries(String aID){
        String sql = "SELECT userName, weaponName, weaponID, patrolName, patrolID, duration FROM userInfo LEFT JOIN Weapons on userInfo.userID = weapons.assignedTo LEFT JOIN Patrol on userInfo.userID = patrol.assignedUser LEFT JOIN AreaInfo on patrol.assignedArea = areainfo.areaID WHERE areaID = '"+aID+"'";
        try{
            Statement statement = Connect.getConnection().createStatement();
            ResultSet result = statement.executeQuery(sql);
            int count = 0;
            
            while(result.next()){
                String uN = result.getString(1);
                String wN = result.getString(2);
                String wID = result.getString(3);
                String pN = result.getString(4);
                String pID = result.getString(5);
                String pD = result.getString(6);
                areaRep = new AreaRep(uN, wN, wID, pN, pID, pD);
                areaRepList.add(areaRep);               
            }
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return areaRepList;    
    }
    
}
