/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package militarydb;

import java.io.FileInputStream;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javafx.scene.Scene;
import javafx.scene.layout.*;
import javafx.scene.text.*;
import javafx.scene.control.Button;
import javafx.scene.control.*;
import javax.swing.JOptionPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import java.util.Arrays;
import java.util.*;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;

/**
 *
 * @author Mike
 */
public class MainApp extends Application {
    private Scene scene;
    private Scene weaScene;
    private Scene patScene;
    private Scene aScene;
    private Scene areaRepScene;
    
    private Stage weaStage = new Stage();
    private Stage patStage = new Stage();
    private Stage aStage = new Stage();
    private Stage areaRepStage = new Stage();
    
    private BorderPane bPane;
    private BorderPane weaPane = new BorderPane();
    private BorderPane patPane = new BorderPane();
    private BorderPane aPane = new BorderPane();
    private BorderPane areaRepPane = new BorderPane();
 
    private VBox login;
    
    private TableView userTable = new TableView();  //table used for displaying user results
    private TableView weaponTable = new TableView();    //table used for displaying weapon results
    private TableView patrolTable = new TableView();    //table used for displaying patrol results
    private TableView areaTable = new TableView();  //table used for displaying area results
    private TableView areaRepTable = new TableView();   //table used for displaying area report results
      
    private static Connection conn;
    
    //table columns used to display information for each view
    private static TableColumn<User, String> nameC; 
    private static TableColumn<User, String> rankC; 
    private static TableColumn<User, String> passC;
    private static TableColumn<User, String> awC;
    private static TableColumn<User, String> apC;
    private static TableColumn<User, String> tisC;
    private static TableColumn<User, String> ssnC;
    private static TableColumn<User, String> dobC;
    
    private static TableColumn<Weapon, String> WIDC;
    private static TableColumn<Weapon, String> WNameC;
    private static TableColumn<Weapon, String> WCC;
    private static TableColumn<Weapon, String> WATC;
    private static TableColumn<Weapon, String> wAUC;
    
    private static TableColumn<Patrol, String> PIDC;
    private static TableColumn<Patrol, String> PNC;
    private static TableColumn<Patrol, String> PAAC;
    private static TableColumn<Patrol, String> PDC;
    private static TableColumn<Patrol, String> PAUC;
    
    private static TableColumn<Area, String> AIDC;
    private static TableColumn<Area, String> ANC;
    private static TableColumn<Area, String> ASLC;
    
    private static TableColumn<AreaRep, String> ARUC;
    private static TableColumn<AreaRep, String> ARUWNC;
    private static TableColumn<AreaRep, String> ARUWIDC;
    private static TableColumn<AreaRep, String> ARUPNC;
    private static TableColumn<AreaRep, String> ARUPIDC;
    private static TableColumn<AreaRep, String> ARUPDC;
     
    //variables used to check if columns have been created yet or not in displays in order to prevent duplicate columns being created
    private static boolean userColC;    
    private static boolean weaponColC;
    private static boolean patrolColC;
    private static boolean areaColC; 
    private static boolean areaRepColC;
    
    //Lists used to hold information to be displayed in tables
    private static List <User> userList = new ArrayList();
    private static ObservableList<User> userListObserve = FXCollections.observableList(userList);
    
    private static List<Weapon> weaponList = new ArrayList();
    private static ObservableList<Weapon> weaponListObserve = FXCollections.observableList(weaponList);
    
    private static List<Patrol> patrolList = new ArrayList();
    private static ObservableList<Patrol> patrolListObserve = FXCollections.observableList(patrolList);    
 
    private static List<Area> areaList = new ArrayList();
    private static ObservableList<Area> areaListObserve = FXCollections.observableList(areaList);        
    
    private static List<AreaRep> areaRepList = new ArrayList();
    private static ObservableList<AreaRep> areaRepListObserve = FXCollections.observableList(areaRepList);
    
    //Pop-up alerts to inform the user of db operations
    private Alert addedAlert = new Alert(Alert.AlertType.INFORMATION, "Entry Added");
    private Alert deleteAlert = new Alert(Alert.AlertType.INFORMATION, "Entry Deleted");
    private Alert updateAlert = new Alert(Alert.AlertType.INFORMATION, "Entry Updated");
    private Alert weapAddAlert = new Alert(Alert.AlertType.WARNING, "Error. User ID Required.");    
    
    @Override
    public void start(Stage primaryStage) {
        bPane = new BorderPane();
        userColC = false;
        scene = new Scene(bPane, 900, 650);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Military Database");
        primaryStage.show();
        userLogin();
        
        //weapon management menu
        weaScene = new Scene(weaPane, 900, 600);
        weaStage.setTitle("Weapon Management");
        weaStage.setScene(weaScene); 
        
        //Patrol management menu
        patScene = new Scene(patPane, 800, 600);
        patStage.setTitle("Patrol Management");
        patStage.setScene(patScene);  
        
        //Area management menu
        aScene = new Scene(aPane, 800, 600);
        aStage.setTitle("Area Management");
        aStage.setScene(aScene); 

        //Area Report menu
        areaRepScene = new Scene(areaRepPane, 750, 300);
        areaRepStage.setTitle("Generate Area Report");
        areaRepStage.setScene(areaRepScene);        
               
    }
     
    //Login Page
     public void userLogin(){       
        login = new VBox();
        login.setOpacity(1);
               
        Alert alert = new Alert(Alert.AlertType.ERROR, "Wrong Login");
        Alert alert2 = new Alert(Alert.AlertType.INFORMATION, "Welcome!");
                
        Text header = new Text("Military Base Security Team Database");
        header.setFont(new Font("Trebuchet MS",30));

        Label uLbl = new Label("Username:");
        Label pLbl = new Label("Password:");

        TextField uBox = new TextField();
        PasswordField pBox = new PasswordField();
        uBox.setMaxWidth(200);
        pBox.setMaxWidth(200);

        Button btn1 = new Button("Submit");        

        login.getChildren().addAll(header, uLbl, uBox, pLbl, pBox, btn1);
        login.setAlignment(Pos.CENTER);
         
        //login button 
        btn1.setOnAction(e -> {            
            try{
                int auth = 0;
                auth = DBOps.checkUser(uBox.getText(), pBox.getText());

                if(auth > 0){
                    login.setOpacity(0);
                    alert2.showAndWait();
                    Connect.test();
                    mainDisplay();
                }else{
                   alert.showAndWait();
                }
            }catch(Exception ex){
                ex.printStackTrace();
            }
        });
        
        bPane.setCenter(login);
        
        //when the user presses enter 
        pBox.setOnKeyPressed(e -> {            
            if (e.getCode() == KeyCode.ENTER) {
                btn1.fire();
            }
        });        
        
     }
     
     //Main user display method
     public void mainDisplay(){
        MenuBar menuBar = new MenuBar();
        
        Menu menu1 = new Menu("Operations");
        Menu menu2 = new Menu("Management");
        Menu menu3 = new Menu("Reports");
        
        MenuItem insertUser = new MenuItem("Insert");
        MenuItem updateUser = new MenuItem("Update");
        MenuItem deleteUser = new MenuItem("Delete");
        MenuItem refreshDB = new MenuItem("Refresh Database");
        MenuItem clearInfo = new MenuItem("Clear Datafields");
        MenuItem exit = new MenuItem("Exit");
        
        MenuItem weaponMan = new MenuItem("Weapon Management");
        MenuItem patrolMan = new MenuItem("Patrol Management");
        MenuItem areaMan = new MenuItem("Area Management");
        
        MenuItem areaReport = new MenuItem("Area Demographics Report");
        
        SeparatorMenuItem separator = new SeparatorMenuItem();
        
        insertUser.setAccelerator(KeyCombination.keyCombination("Ctrl+I"));
        updateUser.setAccelerator(KeyCombination.keyCombination("Ctrl+U"));
        deleteUser.setAccelerator(KeyCombination.keyCombination("Ctrl+D"));
        refreshDB.setAccelerator(KeyCombination.keyCombination("F5"));
        clearInfo.setAccelerator(KeyCombination.keyCombination("F10"));
        
        menu1.getItems().addAll(insertUser, updateUser, deleteUser, refreshDB, clearInfo, separator,  exit);
        menu2.getItems().addAll(weaponMan, patrolMan, areaMan);
        menu3.getItems().addAll(areaReport);
        
        menuBar.getMenus().addAll(menu1, menu2, menu3);  
          
        VBox dbHolder = new VBox();
        VBox ops = new VBox();
        VBox info = new VBox();
        VBox man = new VBox();
        VBox mBox = new VBox();
        
        mBox.getChildren().add(menuBar);
        
        dbHolder.setDisable(false);
        man.setDisable(false);
        ops.setDisable(false);
        info.setDisable(false);
        userTable.setDisable(false);
        menuBar.setDisable(false);
        
        dbHolder.setOpacity(1);
        userTable.setOpacity(1);
        ops.setOpacity(1);
        info.setOpacity(1);
        man.setOpacity(1);
        menuBar.setOpacity(1);
        
        info.setMaxWidth(210);
        info.setMaxHeight(50);
                
        nameC = new TableColumn<>("User Name");
        rankC = new TableColumn<>("Rank");
        awC = new TableColumn<>("Assigned Weapon");
        apC = new TableColumn<>("Assigned Patrol");
        ssnC = new TableColumn<>("Social Security Number");
        
        Label idL = new Label("User ID");
        Label nameL = new Label("Name 'First, Last'");
        Label rankL = new Label("Rank 'EXX or OXX'");
        Label weaL = new Label("Weapon ID");
        Label patIDL = new Label("Patrol ID");
        Label passL = new Label("User Password");
        Label SSNL = new Label("SSN");
        Label DOBL = new Label("Date of Birth 'YYYYMMDD'");
        
        TextField nameTF = new TextField();
        TextField rankTF = new TextField();
        TextField weaTF = new TextField();
        TextField patIDTF = new TextField();
        TextField passTF = new TextField();     
        TextField SSNTF = new TextField();
        TextField DOBTF = new TextField();
        TextField idTF = new TextField();
        TextField pNTF = new TextField();
        TextField wNTF = new TextField();
        idTF.setEditable(false);
        weaTF.setEditable(false);
        patIDTF.setEditable(false);
        
        nameTF.setMaxWidth(200);
        rankTF.setMaxWidth(200);
        passTF.setMaxWidth(200);
        SSNTF.setMaxWidth(200);
        DOBTF.setMaxWidth(200);
        idTF.setMaxWidth(200);
        
        info.getChildren().addAll(idL, idTF, nameL, nameTF, rankL, rankTF, weaL, weaTF, patIDL, patIDTF, passL, passTF, SSNL, SSNTF, DOBL, DOBTF);
        
        Button exitBtn = new Button("Exit");
        Button inBtn = new Button("Insert");
        Button upBtn = new Button("Update");
        Button delBtn = new Button("Delete");
        Button refBtn = new Button("Refresh DB");
        Button clearBtn = new Button("Clear Fields");
        Button weaBtn = new Button("Weapon Management");
        Button patBtn = new Button("Patrol Management");
        
        ops.getChildren().addAll(inBtn, upBtn, delBtn, refBtn, clearBtn, exitBtn);
        
        man.getChildren().addAll(weaBtn, patBtn);
        
        dbHolder.getChildren().addAll(userTable);
        
        dbHolder.setPadding(new Insets(10));
        info.setPadding(new Insets(30));       
                
        //check if columns created, if they are do not create again
        if(userColC == false){
            userTable.getColumns().addAll(nameC, rankC, awC, apC, ssnC);
            userColC = true;
        }       
               
        bPane.setTop(mBox);
        bPane.setCenter(dbHolder);
        bPane.setRight(info);
        
        //When 'Exit' is pressed
        exit.setOnAction(e -> {
            try{
                dbHolder.setOpacity(0);              
                ops.setOpacity(0);
                info.setOpacity(0);
                man.setOpacity(0);
                menuBar.setOpacity(0);
                
                dbHolder.setDisable(true);
                ops.setDisable(true);
                info.setDisable(true);
                man.setDisable(true);
                menuBar.setDisable(true);
                
                weaStage.close();
                patStage.close();
                aStage.close();
                
                Connect.closrC();
                
                System.out.println("Connection closed");
                
                userLogin();
            }catch(Exception ex){
                ex.printStackTrace();
            }
           
        });
        
        //When entry is selected in userTable
        userTable.setOnMouseClicked(e -> {
            if(userTable.getSelectionModel().getSelectedItem() != null){
                User selected = new User();
                selected = (User) userTable.getSelectionModel().getSelectedItem();
                
                idTF.setText(selected.getID());
                nameTF.setText(selected.getName());
                passTF.setText(selected.getPass());
                rankTF.setText(selected.getRank());
                SSNTF.setText(selected.getSSN());
                DOBTF.setText(selected.getDOB());
                weaTF.setText(selected.getAW());
                patIDTF.setText(selected.getAP());
            }
        });
 
        //When 'Insert' is pressed
        insertUser.setOnAction(e -> {
            try{
                int res = DBOps.insertUserEntry(nameTF.getText(), passTF.getText(), rankTF.getText(), SSNTF.getText(), DOBTF.getText());
                nameTF.clear();
                passTF.clear();
                rankTF.clear();
                SSNTF.clear();
                DOBTF.clear();
                idTF.clear();
                pNTF.clear();
                wNTF.clear();
                
                if(res > 0)
                    addedAlert.showAndWait();
                
                userList.clear();
                userList = DBOps.selectUserEntries();
                userListObserve = FXCollections.observableList(userList);
                userTable.setItems(userListObserve);
                              
                nameC.setCellValueFactory(new PropertyValueFactory("name"));
                rankC.setCellValueFactory(new PropertyValueFactory("rank"));
                awC.setCellValueFactory(new PropertyValueFactory("weaN"));
                apC.setCellValueFactory(new PropertyValueFactory("patN"));
                ssnC.setCellValueFactory(new PropertyValueFactory("SSN"));              
            }catch(Exception ex){
                ex.printStackTrace();
            }
           
        });
        
        //When 'Refresh DB' is pressed
        refreshDB.setOnAction(e -> {
            try{
                userList.clear();
                userList = DBOps.selectUserEntries();
                userListObserve = FXCollections.observableList(userList);
                userTable.setItems(userListObserve);
                             
                nameC.setCellValueFactory(new PropertyValueFactory("name"));
                rankC.setCellValueFactory(new PropertyValueFactory("rank"));
                awC.setCellValueFactory(new PropertyValueFactory("weaN"));
                apC.setCellValueFactory(new PropertyValueFactory("patN"));
                ssnC.setCellValueFactory(new PropertyValueFactory("SSN"));  
            }catch(Exception ex){
                ex.printStackTrace();
            }          
        });     
        
        //When 'Delete' is pressed
        deleteUser.setOnAction(e -> {
            try{
                int res = DBOps.deleteUserEntry(idTF.getText());
                
                if(res > 0)
                    deleteAlert.showAndWait();
                
                userList.clear();
                userList = DBOps.selectUserEntries();
                userListObserve = FXCollections.observableList(userList);
                userTable.setItems(userListObserve);
                             
                nameC.setCellValueFactory(new PropertyValueFactory("name"));
                rankC.setCellValueFactory(new PropertyValueFactory("rank"));
                awC.setCellValueFactory(new PropertyValueFactory("weaN"));
                apC.setCellValueFactory(new PropertyValueFactory("patN"));
                ssnC.setCellValueFactory(new PropertyValueFactory("SSN"));              
                
                deleteAlert.showAndWait();
            }catch(Exception ex){
                ex.printStackTrace();
            }          
        });
        
        //when 'clear fields' is pressed
        clearInfo.setOnAction(e -> {
            try{
                nameTF.clear();
                passTF.clear();
                rankTF.clear();
                SSNTF.clear();
                DOBTF.clear();
                idTF.clear();
                weaTF.clear();
                patIDTF.clear();
            }catch(Exception ex){
                ex.printStackTrace();
            }          
        });
               
        //when 'update' is pressed
        updateUser.setOnAction(e -> {
            try{
                int res = DBOps.updateUser(idTF.getText(), nameTF.getText(), passTF.getText(), rankTF.getText(), SSNTF.getText(), DOBTF.getText());
                
                if(res > 0)
                    updateAlert.showAndWait();
                
                userList.clear();
                userList = DBOps.selectUserEntries();
                userListObserve = FXCollections.observableList(userList);
                userTable.setItems(userListObserve);
                              
                nameC.setCellValueFactory(new PropertyValueFactory("name"));
                rankC.setCellValueFactory(new PropertyValueFactory("rank"));
                awC.setCellValueFactory(new PropertyValueFactory("weaN"));
                apC.setCellValueFactory(new PropertyValueFactory("patN"));
                ssnC.setCellValueFactory(new PropertyValueFactory("SSN"));              
            }catch(Exception ex){
                ex.printStackTrace();
            }          
        });         
        
        //when 'weapon management' is pressed
        weaponMan.setOnAction(e -> {
            weaStage.show();
            weapDisplay();
        }); 

        //when 'patrol management' is pressed
        patrolMan.setOnAction(e -> {
            patStage.show();
            patDisplay();
        });   
        
        //when 'area management' is pressed
        areaMan.setOnAction(e -> {
            aStage.show();
            areaDisplay();
        }); 
              
        //when area report is pressed
        areaReport.setOnAction(e -> {
            areaRepStage.show();
            areaRepDisplay();
        });         
        
        refreshDB.fire();
     }

     //Weapon display method
     public void weapDisplay(){ 
        MenuBar menuBar = new MenuBar();
        
        Menu menu1 = new Menu("Operations");
        
        MenuItem insertWeapon = new MenuItem("Insert");
        MenuItem updateWeapon = new MenuItem("Update");
        MenuItem deleteWeapon = new MenuItem("Delete");
        MenuItem refreshDB = new MenuItem("Refresh Database");
        MenuItem clearInfo = new MenuItem("Clear Datafields");
        MenuItem exit = new MenuItem("Exit");
        SeparatorMenuItem separator = new SeparatorMenuItem();
                      
        insertWeapon.setAccelerator(KeyCombination.keyCombination("Ctrl+I"));
        updateWeapon.setAccelerator(KeyCombination.keyCombination("Ctrl+U"));
        deleteWeapon.setAccelerator(KeyCombination.keyCombination("Ctrl+D"));
        refreshDB.setAccelerator(KeyCombination.keyCombination("F5"));
        clearInfo.setAccelerator(KeyCombination.keyCombination("F10"));
        
        menu1.getItems().addAll(insertWeapon, updateWeapon, deleteWeapon, refreshDB, clearInfo, separator, exit);        
         
        VBox dbHolder = new VBox();
        VBox info = new VBox(); 
        VBox mBox = new VBox();
        
        menuBar.getMenus().addAll(menu1);
        mBox.getChildren().add(menuBar);
        
        Button exitBtn = new Button("Exit");
        Button inBtn = new Button("Insert");
        Button upBtn = new Button("Update");
        Button delBtn = new Button("Delete");
        Button refBtn = new Button("Refresh DB");
        Button clearBtn = new Button("Clear Fields");  
        
        Label wIDL = new Label("Weapon ID");
        Label wNL = new Label("Weapon Name");
        Label wCL = new Label("Weapon Condition '0-Deadline | 1-Under Repair | 2-Serviceable'");
        Label wATL = new Label("Assigned To ID");
        
        TextField wIDTF = new TextField();
        TextField wNTF = new TextField();
        TextField wCTF = new TextField();
        TextField wATTF = new TextField();
        TextField wATNTF = new TextField();
        wIDTF.setEditable(false);
        
        info.getChildren().addAll(wIDL, wIDTF, wCL, wCTF, wATL, wATTF, wNL, wNTF);
               
        dbHolder.getChildren().addAll(weaponTable);        
        
        WIDC = new TableColumn<>("Weapon ID");
        WNameC = new TableColumn<>("Weapon Name");
        WCC = new TableColumn<>("Weapon Condition");
        WATC = new TableColumn<>("Assigned To ID");
        wAUC = new TableColumn<>("Assigned To Name");
        
        //check if columns created, if they are do not create again
        if(weaponColC == false){
            weaponTable.getColumns().addAll(WIDC, WNameC, WCC, WATC, wAUC);
            weaponColC = true;
        }                
        
        info.setPadding(new Insets(10));
        dbHolder.setPadding(new Insets(10));       
        
        weaPane.setTop(mBox);
        weaPane.setCenter(dbHolder);
        weaPane.setRight(info);
        
        //when a entry is clicked
        weaponTable.setOnMouseClicked(e -> {
            if(weaponTable.getSelectionModel().getSelectedItem() != null){
                Weapon selected = new Weapon();
                selected = (Weapon) weaponTable.getSelectionModel().getSelectedItem();
                
                wIDTF.setText(selected.getWID());
                wNTF.setText(selected.getWName());
                wCTF.setText(selected.getCond());
                wATTF.setText(selected.getAT());
                wATNTF.setText(selected.getWAU());
            }
        }); 
        
        //When 'Insert' is pressed
        insertWeapon.setOnAction(e -> {
            try{
                int res = DBOps.insertWeaponEntry(wCTF.getText(), wATTF.getText(), wNTF.getText());
                wNTF.clear();
                wCTF.clear();
                wATTF.clear();
                wIDTF.clear();
                wATNTF.clear();
                
                if(res > 0){
                    addedAlert.showAndWait();
                }else{
                    weapAddAlert.showAndWait();
                }
                
                weaponList.clear();
                weaponList = DBOps.selectWeaponEntries();
                weaponListObserve = FXCollections.observableList(weaponList);
                weaponTable.setItems(weaponListObserve);
                
                WNameC.setCellValueFactory(new PropertyValueFactory("wName"));               
                WCC.setCellValueFactory(new PropertyValueFactory("cond"));
                WATC.setCellValueFactory(new PropertyValueFactory("aT"));
                WIDC.setCellValueFactory(new PropertyValueFactory("wID"));
                wAUC.setCellValueFactory(new PropertyValueFactory("wAU"));
            }catch(Exception ex){
                ex.printStackTrace();
            }
           
        });        

        //when 'update' is pressed
        updateWeapon.setOnAction(e -> {
            try{
                
                int res = DBOps.updateWeapon(wIDTF.getText(), wCTF.getText(), wATTF.getText(), wNTF.getText());
                
                if(res > 0)
                    updateAlert.showAndWait();
                
                weaponList.clear();
                weaponList = DBOps.selectWeaponEntries();
                weaponListObserve = FXCollections.observableList(weaponList);
                weaponTable.setItems(weaponListObserve);
                
                WNameC.setCellValueFactory(new PropertyValueFactory("wName"));               
                WCC.setCellValueFactory(new PropertyValueFactory("cond"));
                WATC.setCellValueFactory(new PropertyValueFactory("aT"));
                WIDC.setCellValueFactory(new PropertyValueFactory("wID"));
                wAUC.setCellValueFactory(new PropertyValueFactory("wAU"));
            }catch(Exception ex){
                ex.printStackTrace();
            }          
        }); 

        //when 'clear fields' is pressed
        clearInfo.setOnAction(e -> {
            try{
                wIDTF.clear();
                wCTF.clear();
                wATTF.clear();
                wNTF.clear();
            }catch(Exception ex){
                ex.printStackTrace();
            }          
        });       
 
        //When 'Delete' is pressed
        deleteWeapon.setOnAction(e -> {
            try{
                int res = DBOps.deleteWeaponEntry(wIDTF.getText());
                
                if(res > 0)
                    deleteAlert.showAndWait();
                
                weaponList.clear();
                weaponList = DBOps.selectWeaponEntries();
                weaponListObserve = FXCollections.observableList(weaponList);
                weaponTable.setItems(weaponListObserve);
                
                WNameC.setCellValueFactory(new PropertyValueFactory("wName"));               
                WCC.setCellValueFactory(new PropertyValueFactory("cond"));
                WATC.setCellValueFactory(new PropertyValueFactory("aT"));
                WIDC.setCellValueFactory(new PropertyValueFactory("wID"));
                wAUC.setCellValueFactory(new PropertyValueFactory("wAU"));               
                
            }catch(Exception ex){
                ex.printStackTrace();
            }          
        });        
 
        //when 'refresh db' is pressed
        refreshDB.setOnAction(e -> {
            try{
                weaponList.clear();
                weaponList = DBOps.selectWeaponEntries();
                weaponListObserve = FXCollections.observableList(weaponList);
                weaponTable.setItems(weaponListObserve);
                
                WNameC.setCellValueFactory(new PropertyValueFactory("wName"));               
                WCC.setCellValueFactory(new PropertyValueFactory("cond"));
                WATC.setCellValueFactory(new PropertyValueFactory("aT"));
                WIDC.setCellValueFactory(new PropertyValueFactory("wID"));
                wAUC.setCellValueFactory(new PropertyValueFactory("wAU"));               
            }catch(Exception ex){
                ex.printStackTrace();
            }          
        });         
                   
        //when 'exit' is pressed
        exit.setOnAction(e -> {
            weaStage.close();
        });                  
        
        refreshDB.fire();          
        
     }
     
    //Patrol display method
    public void patDisplay(){
       MenuBar menuBar = new MenuBar();

       Menu menu1 = new Menu("Operations");

       MenuItem insertPatrol = new MenuItem("Insert");
       MenuItem updatePatrol = new MenuItem("Update");
       MenuItem deletePatrol = new MenuItem("Delete");
       MenuItem refreshDB = new MenuItem("Refresh Database");
       MenuItem clearInfo = new MenuItem("Clear Datafields");
       MenuItem exit = new MenuItem("Exit");
       SeparatorMenuItem separator = new SeparatorMenuItem();

       insertPatrol.setAccelerator(KeyCombination.keyCombination("Ctrl+I"));
       updatePatrol.setAccelerator(KeyCombination.keyCombination("Ctrl+U"));
       deletePatrol.setAccelerator(KeyCombination.keyCombination("Ctrl+D"));
       refreshDB.setAccelerator(KeyCombination.keyCombination("F5"));
       clearInfo.setAccelerator(KeyCombination.keyCombination("F10"));

       menu1.getItems().addAll(insertPatrol, updatePatrol, deletePatrol, refreshDB, clearInfo, separator, exit);        

       VBox dbHolder = new VBox();
       VBox info = new VBox(); 
       VBox mBox = new VBox();

       menuBar.getMenus().addAll(menu1);
       mBox.getChildren().add(menuBar);

       Button exitBtn = new Button("Exit");
       Button inBtn = new Button("Insert");
       Button upBtn = new Button("Update");
       Button delBtn = new Button("Delete");
       Button refBtn = new Button("Refresh DB");
       Button clearBtn = new Button("Clear Fields"); 

       Label pIDL = new Label("Patrol ID");
       Label pNL = new Label("Patrol Name");
       Label pAUL = new Label("Assigned User ID");
       Label pAAL = new Label("Area Assigned ID");
       Label pADL = new Label("Patrol Duration (Hours)");

       TextField pIDTF = new TextField();
       TextField pNTF = new TextField();
       TextField pAUNTF = new TextField();
       TextField pAATF = new TextField();
       TextField pADTF = new TextField();
       TextField pAUTF = new TextField();
       TextField pAANTF = new TextField();
       pIDTF.setEditable(false);    

       info.getChildren().addAll(pIDL, pIDTF, pNL, pNTF, pAAL, pAATF, pAUL, pAUTF, pADL, pADTF);

       dbHolder.getChildren().addAll(patrolTable);        

       PIDC = new TableColumn<>("Patrol ID");
       PNC = new TableColumn<>("Patrol Name");
       PAUC = new TableColumn<>("Assigned User");
       PAAC = new TableColumn<>("Assigned Area");
       PDC = new TableColumn<>("Patrol Duration (Hours)");

       //check if columns created, if they are do not create again
       if(patrolColC == false){
           patrolTable.getColumns().addAll(PIDC, PNC, PAUC, PAAC, PDC);
           patrolColC = true;
       }                

       info.setPadding(new Insets(10));
       dbHolder.setPadding(new Insets(10));        

       patPane.setTop(mBox);
       patPane.setCenter(dbHolder);
       patPane.setRight(info);


       //when a entry is clicked
       patrolTable.setOnMouseClicked(e -> {
           if(patrolTable.getSelectionModel().getSelectedItem() != null){
               Patrol selected = new Patrol();
               selected = (Patrol) patrolTable.getSelectionModel().getSelectedItem();

               pIDTF.setText(selected.getPID());
               pNTF.setText(selected.getPN());
               pAATF.setText(selected.getPAA());
               pADTF.setText(selected.getPDur());
               pAUTF.setText(selected.getPAU());
               pAUNTF.setText(selected.getPAUN());
               pAANTF.setText(selected.getPAN());
           }
       }); 

       //When 'Insert' is pressed
       insertPatrol.setOnAction(e -> {
           try{
               int res = DBOps.insertPatrolEntry(pNTF.getText(), pAUTF.getText(), pAATF.getText(), pADTF.getText());
               pIDTF.clear();
               pNTF.clear();
               pAATF.clear();
               pADTF.clear();
               pAUTF.clear();
               pAUNTF.clear();
               pAANTF.clear();

               if(res > 0)
                   addedAlert.showAndWait();

               patrolList.clear();
               patrolList = DBOps.selectPatrolEntries();
               patrolListObserve = FXCollections.observableList(patrolList);
               patrolTable.setItems(patrolListObserve);

               PIDC.setCellValueFactory(new PropertyValueFactory("pID"));               
               PNC.setCellValueFactory(new PropertyValueFactory("pN"));
               PAUC.setCellValueFactory(new PropertyValueFactory("pAUN"));
               PAAC.setCellValueFactory(new PropertyValueFactory("pAN"));
               PDC.setCellValueFactory(new PropertyValueFactory("pDur"));             
           }catch(Exception ex){
               ex.printStackTrace();
           }

       });        

       //when 'update' is pressed
       updatePatrol.setOnAction(e -> {
           try{

               int res = DBOps.updatePatrol(pIDTF.getText(), pNTF.getText(), pAUTF.getText(), pAATF.getText(), pADTF.getText());

               if(res > 0)
                   updateAlert.showAndWait();

               patrolList.clear();
               patrolList = DBOps.selectPatrolEntries();
               patrolListObserve = FXCollections.observableList(patrolList);
               patrolTable.setItems(patrolListObserve);

               PIDC.setCellValueFactory(new PropertyValueFactory("pID"));               
               PNC.setCellValueFactory(new PropertyValueFactory("pN"));
               PAUC.setCellValueFactory(new PropertyValueFactory("pAUN"));
               PAAC.setCellValueFactory(new PropertyValueFactory("pAN"));
               PDC.setCellValueFactory(new PropertyValueFactory("pDur"));    
           }catch(Exception ex){
               ex.printStackTrace();
           }          
       }); 

       //when 'clear fields' is pressed
       clearInfo.setOnAction(e -> {
           try{
               pIDTF.clear();
               pNTF.clear();
               pAATF.clear();
               pADTF.clear();
               pAUTF.clear();
               pAUNTF.clear();
               pAANTF.clear();
           }catch(Exception ex){
               ex.printStackTrace();
           }          
       });       

       //When 'Delete' is pressed
       deletePatrol.setOnAction(e -> {
           try{
               int res = DBOps.deletePatrolEntry(pIDTF.getText());

               if(res > 0)
                   deleteAlert.showAndWait();

               patrolList.clear();
               patrolList = DBOps.selectPatrolEntries();
               patrolListObserve = FXCollections.observableList(patrolList);
               patrolTable.setItems(patrolListObserve);

               PIDC.setCellValueFactory(new PropertyValueFactory("pID"));               
               PNC.setCellValueFactory(new PropertyValueFactory("pN"));
               PAUC.setCellValueFactory(new PropertyValueFactory("pAUN"));
               PAAC.setCellValueFactory(new PropertyValueFactory("pAN"));
               PDC.setCellValueFactory(new PropertyValueFactory("pDur"));               

           }catch(Exception ex){
               ex.printStackTrace();
           }          
       });        

       //when 'refresh db' is pressed
       refreshDB.setOnAction(e -> {
           try{
               patrolList.clear();
               patrolList = DBOps.selectPatrolEntries();
               patrolListObserve = FXCollections.observableList(patrolList);
               patrolTable.setItems(patrolListObserve);

               PIDC.setCellValueFactory(new PropertyValueFactory("pID"));               
               PNC.setCellValueFactory(new PropertyValueFactory("pN"));
               PAUC.setCellValueFactory(new PropertyValueFactory("pAUN"));
               PAAC.setCellValueFactory(new PropertyValueFactory("pAN"));
               PDC.setCellValueFactory(new PropertyValueFactory("pDur"));                  
           }catch(Exception ex){
               ex.printStackTrace();
           }          
       });         

       //when 'exit' is pressed
       exit.setOnAction(e -> {
           patStage.close();
       });         

       refreshDB.fire();         
    }

    //Area display Method
    public void areaDisplay(){
       MenuBar menuBar = new MenuBar();

       Menu menu1 = new Menu("Operations");

       MenuItem insertArea = new MenuItem("Insert");
       MenuItem updateArea = new MenuItem("Update");
       MenuItem deleteArea = new MenuItem("Delete");
       MenuItem refreshDB = new MenuItem("Refresh Database");
       MenuItem clearInfo = new MenuItem("Clear Datafields");
       MenuItem exit = new MenuItem("Exit");
       SeparatorMenuItem separator = new SeparatorMenuItem();

       insertArea.setAccelerator(KeyCombination.keyCombination("Ctrl+I"));
       updateArea.setAccelerator(KeyCombination.keyCombination("Ctrl+U"));
       deleteArea.setAccelerator(KeyCombination.keyCombination("Ctrl+D"));
       refreshDB.setAccelerator(KeyCombination.keyCombination("F5"));
       clearInfo.setAccelerator(KeyCombination.keyCombination("F10"));

       menu1.getItems().addAll(insertArea, updateArea, deleteArea, refreshDB, clearInfo, separator, exit);        

       VBox dbHolder = new VBox();
       VBox info = new VBox(); 
       VBox mBox = new VBox();

       menuBar.getMenus().addAll(menu1);
       mBox.getChildren().add(menuBar);

       Button exitBtn = new Button("Exit");
       Button inBtn = new Button("Insert");
       Button upBtn = new Button("Update");
       Button delBtn = new Button("Delete");
       Button refBtn = new Button("Refresh DB");
       Button clearBtn = new Button("Clear Fields"); 

       Label aIDL = new Label("Area ID");
       Label aNL = new Label("Area Name");
       Label aSLL = new Label("Area Security Level");

       TextField aIDTF = new TextField();
       TextField aNTF = new TextField();
       TextField aSLTF = new TextField();
       aIDTF.setEditable(false);    

       info.getChildren().addAll(aIDL, aIDTF, aNL, aNTF, aSLL, aSLTF);

       dbHolder.getChildren().addAll(areaTable);        

       AIDC = new TableColumn<>("Area ID");
       ANC = new TableColumn<>("Area Name");
       ASLC = new TableColumn<>("Area Security Level");

       //check if columns created, if they are do not create again
       if(areaColC == false){
           areaTable.getColumns().addAll(AIDC, ANC, ASLC);
           areaColC = true;
       }                

       info.setPadding(new Insets(10));
       dbHolder.setPadding(new Insets(10));        

       aPane.setTop(mBox);
       aPane.setCenter(dbHolder);
       aPane.setRight(info);

       //check if columns created, if they are do not create again
       if(areaColC == false){
           areaTable.getColumns().addAll(AIDC, ANC, ASLC);
           areaColC = true;
       }                

       info.setPadding(new Insets(10));
       dbHolder.setPadding(new Insets(10));        

       aPane.setTop(mBox);
       aPane.setCenter(dbHolder);
       aPane.setRight(info);

       //DB Operations
       //when a entry is clicked
       areaTable.setOnMouseClicked(e -> {
           if(areaTable.getSelectionModel().getSelectedItem() != null){
               Area selected = new Area();
               selected = (Area) areaTable.getSelectionModel().getSelectedItem();

               aIDTF.setText(selected.getAID());
               aNTF.setText(selected.getAN());
               aSLTF.setText(selected.getASL());
           }
       }); 

       //When 'Insert' is pressed
       insertArea.setOnAction(e -> {
           try{
               int res = DBOps.insertAreaEntry(aNTF.getText(), aSLTF.getText());
               aIDTF.clear();
               aNTF.clear();
               aSLTF.clear();

               if(res > 0)
                   addedAlert.showAndWait();

               areaList.clear();
               areaList = DBOps.selectAreaEntries();
               areaListObserve = FXCollections.observableList(areaList);
               areaTable.setItems(areaListObserve);

               AIDC.setCellValueFactory(new PropertyValueFactory("aID"));               
               ANC.setCellValueFactory(new PropertyValueFactory("aN"));
               ASLC.setCellValueFactory(new PropertyValueFactory("aSL"));            
           }catch(Exception ex){
               ex.printStackTrace();
           }

       });        

       //when 'update' is pressed
       updateArea.setOnAction(e -> {
           try{

               int res = DBOps.updateArea(aIDTF.getText(), aNTF.getText(), aSLTF.getText());

               if(res > 0)
                   updateAlert.showAndWait();

               areaList.clear();
               areaList = DBOps.selectAreaEntries();
               areaListObserve = FXCollections.observableList(areaList);
               areaTable.setItems(areaListObserve);

               AIDC.setCellValueFactory(new PropertyValueFactory("aID"));               
               ANC.setCellValueFactory(new PropertyValueFactory("aN"));
               ASLC.setCellValueFactory(new PropertyValueFactory("aSL"));  
           }catch(Exception ex){
               ex.printStackTrace();
           }          
       }); 

       //when 'clear fields' is pressed
       clearInfo.setOnAction(e -> {
           try{
               aIDTF.clear();
               aNTF.clear();
               aSLTF.clear();
           }catch(Exception ex){
               ex.printStackTrace();
           }          
       });       

       //When 'Delete' is pressed
       deleteArea.setOnAction(e -> {
           try{
               int res = DBOps.deleteAreaEntry(aIDTF.getText());

               if(res > 0)
                   deleteAlert.showAndWait();

               areaList.clear();
               areaList = DBOps.selectAreaEntries();
               areaListObserve = FXCollections.observableList(areaList);
               areaTable.setItems(areaListObserve);

               AIDC.setCellValueFactory(new PropertyValueFactory("aID"));               
               ANC.setCellValueFactory(new PropertyValueFactory("aN"));
               ASLC.setCellValueFactory(new PropertyValueFactory("aSL"));               

           }catch(Exception ex){
               ex.printStackTrace();
           }          
       });        

       //when 'refresh db' is pressed
       refreshDB.setOnAction(e -> {
           try{
               areaList.clear();
               areaList = DBOps.selectAreaEntries();
               areaListObserve = FXCollections.observableList(areaList);
               areaTable.setItems(areaListObserve);

               AIDC.setCellValueFactory(new PropertyValueFactory("aID"));               
               ANC.setCellValueFactory(new PropertyValueFactory("aN"));
               ASLC.setCellValueFactory(new PropertyValueFactory("aSL"));                 
           }catch(Exception ex){
               ex.printStackTrace();
           }          
       });         

       //when 'exit' is pressed
       exit.setOnAction(e -> {
           aStage.close();
       });         

       refreshDB.fire();          
    }
    
    //Area Demographic Report Display
    public void areaRepDisplay(){
        VBox h1 = new VBox(5);
        VBox dbHolder = new VBox();

        ARUC = new TableColumn<>("User");
        ARUWNC = new TableColumn<>("Weapon Name");
        ARUWIDC = new TableColumn<>("Weapon ID");
        ARUPNC = new TableColumn<>("Patrol Name");
        ARUPIDC = new TableColumn<>("Patrol ID");
        ARUPDC = new TableColumn<>("Patrol Duration (Hours)");
        
        //check if columns created, if they are do not create again
        if(areaRepColC == false){
            areaRepTable.getColumns().addAll(ARUC, ARUWNC, ARUWIDC, ARUPNC, ARUPIDC, ARUPDC);
            areaRepColC = true;
        }         
        
        Label aIDL = new Label("Enter Area ID");
        
        Text aRInfo = new Text("Generate a report that presents the users, weapon systems, and patrols currently active in a given area");
        aRInfo.setWrappingWidth(160.0);
        
        TextField aIDTF = new TextField();

        Button genBtn = new Button("Generate Report");
        Button prtBtn = new Button("Print Report");

        dbHolder.getChildren().addAll(areaRepTable);  
        
        h1.setPadding(new Insets(10));
        dbHolder.setPadding(new Insets(10));

        h1.getChildren().addAll(aRInfo, aIDL, aIDTF, genBtn, prtBtn);
        areaRepPane.setLeft(h1);
        areaRepPane.setCenter(dbHolder);
  
        //when 'generate report' is pressed
        genBtn.setOnAction(e -> {
            try{
                areaRepList.clear();
                areaRepList = DBOps.selectAreaRepEntries(aIDTF.getText());
                areaRepListObserve = FXCollections.observableList(areaRepList);
                areaRepTable.setItems(areaRepListObserve);
                
                ARUC.setCellValueFactory(new PropertyValueFactory("aRUN"));               
                ARUWNC.setCellValueFactory(new PropertyValueFactory("aRUWN"));
                ARUWIDC.setCellValueFactory(new PropertyValueFactory("aRUWID"));
                ARUPNC.setCellValueFactory(new PropertyValueFactory("aRUPN"));
                ARUPIDC.setCellValueFactory(new PropertyValueFactory("aRUPID"));
                ARUPDC.setCellValueFactory(new PropertyValueFactory("aRUPD"));
            }catch(Exception ex){
                ex.printStackTrace();
            } 
        }); 
        
      
         
     }
        
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }
    
}

