# Michael Amey
# Military Base Security Team Database
-- This j connect driver is using the username 'root' and password 'rootpass' 
-- To change the username and password to what your current settings are for your
-- version of MySql, edit the username and password strings in the Connect.java file 

CREATE DATABASE db_michaelameyproject; 
CREATE USER student@localhost;
GRANT ALL PRIVILEGES ON db_michaelameyproject.* TO 'student '@' localhost';
FLUSH PRIVILEGES;
use db_michaelameyproject;

-- Create table to hold user information as well as act as default display 
CREATE TABLE UserInfo(
	userID char(38) NOT NULL,
    userName varchar(50),
    userPass varchar(50),
    userRank varchar(3),
    timeInService decimal(3, 2),
    SSN int(9),
    DOB int(8),
    PRIMARY KEY (userID)
    );

-- Create table to hold information about weapons 
CREATE TABLE Weapons(
	weaponID char(38) NOT NULL,
    conditionStatus varchar(25),
    assignedTo char(38),
    weaponName varChar(50),
    PRIMARY KEY (weaponID)
    );

-- Create table to create and manage different areas of the base as well as to help 
-- organize patrols and enforce security through different secuity levels
CREATE TABLE AreaInfo(
	areaID char(38) NOT NULL,
    areaName char(50),
    securityLevel int,
    PRIMARY KEY (areaID)
    );

-- Create table thats holds patrols for each individual user
CREATE TABLE Patrol(
	patrolID char(38) NOT NULL,
    patrolName char(50),
    assignedUser char(38),
    assignedArea char(38),
    duration int,
    PRIMARY KEY (patrolID)
    );
    
-- Assign foreign key in weapons table that refernces userID in user table
-- to tie users with assigned weapons
ALTER TABLE Weapons
ADD CONSTRAINT FK_FromUserw FOREIGN KEY (assignedTo) REFERENCES UserInfo (userID) ON DELETE CASCADE;

-- Assign foreign key in patrol tables that connects a user with a assigned patrol
-- while also connecting patrols with specific defined areas
ALTER TABLE Patrol
ADD CONSTRAINT FK_FromUserInfop FOREIGN KEY (assignedUser) REFERENCES UserInfo (userID) ON DELETE CASCADE,
ADD CONSTRAINT FK_FromAreap FOREIGN KEY (assignedArea) REFERENCES AreaInfo (areaID) ON DELETE CASCADE;

-- Insert default user into userInfo table 
INSERT INTO userInfo(userID, userName, userPass)
VALUES(uuid(), 'jdoe', sha('pass#1'));